/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vpd.vpdedit;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.vpd.vpdedit.ChangeFruDataBean;
import com.ibm.hwmca.base.vpd.vpdedit.ChangeMachineConfigDataBean;
import com.ibm.hwmca.base.vpd.vpdedit.DisplayLocationsBean;
import com.ibm.hwmca.base.vpd.vpdedit.SearchKeyWordBean;
import com.ibm.hwmca.base.vpd.vpdedit.TypeOfSearchBean;
import com.ibm.hwmca.base.vpd.vpdedit.VpdEditBean;
import com.ibm.hwmca.base.vpdmgr.VpdConfigurationData;
import com.ibm.hwmca.base.vpdmgr.VpdData;
import com.ibm.hwmca.base.vpdmgr.VpdDeviceData;
import com.ibm.hwmca.base.vpdmgr.VpdFileRecord;
import com.ibm.hwmca.base.vpdmgr.VpdFruData;
import com.ibm.hwmca.base.vpdmgr.VpdManager;
import com.ibm.hwmca.base.vpdmgr.VpdManagerException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerNotFoundException;
import com.ibm.hwmca.base.vpdmgr.VpdRequestValue;
import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class VpdEditTasklet
extends PanelTasklet {
    private static final String TRACE_MASKT = "XVPD   T";
    private static final String TRACE_MASKF = "XVPD   F";
    private static final String TRACE_MASKD = "XVPD   D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(47, "VpdEditTasklet");
    private static final String VPD_FN = "iqyvpd.dat";
    private static final String VPDC_FN = "iqyvpdc.dat";
    private byte[] vpdfile;
    private byte[] vpdcfile;
    private NativeBridge bridge;
    private List frus;
    private int currentIndex;
    private int numVpdRecords;
    private String typeOfSearchString;
    private VpdRequestValue lastAction;
    private VpdFileRecord lastRecord;
    private int lastIndex;
    private VpdConfigurationData saveMachCfgData;
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.vpd.vpdedit.res.VpdEditRes";
    private static final String MAIN_PANEL_NAME = "VpdEditPanel";
    private static final String DISPLAY_LOCS_PANEL_NAME = "DisplayLocationsPanel";
    private static final String MACH_CFG_PANEL_NAME = "ChangeMachineConfigDataPanel";
    private static final String SEARCH_TYPE_PANEL_NAME = "TypeOfSearchPanel";
    private static final String CHANGE_FRU_DATA_PANEL_NAME = "ChangeFruDataPanel";
    private static final String SEARCH_STRING_PANEL_NAME = "SearchKeyWordPanel";

    public void init() throws TaskletException {
        this.currentIndex = 0;
        this.lastRecord = null;
        this.lastIndex = 0;
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        block56: {
            Trace.trace(TRACE_MASKT, "-> VpdEditTasklet.service()");
            try {
                if (taskletRequest.isInitialRequest()) {
                    String dataFilePath = BaseFileControl.getFilePath(VPD_FN);
                    FileInputStream vpdStream = new FileInputStream(dataFilePath + VPD_FN);
                    this.vpdfile = new byte[vpdStream.available()];
                    vpdStream.read(this.vpdfile);
                    vpdStream.close();
                    vpdStream = new FileInputStream(dataFilePath + VPDC_FN);
                    this.vpdcfile = new byte[vpdStream.available()];
                    vpdStream.read(this.vpdcfile);
                    vpdStream.close();
                    VpdEditBean bean = new VpdEditBean();
                    taskletResponse.replace(AUIML_FILE_NAME, MAIN_PANEL_NAME, bean);
                    break block56;
                }
                if (taskletRequest.isDisposed()) {
                    taskletResponse.dispose();
                    break block56;
                }
                String actionString = (String)taskletRequest.getData("action");
                if (actionString.equals("DisplayOrAlterRb")) {
                    Trace.trace(TRACE_MASKF, "Display all the VPD locations");
                    this.getAllVpdLocations();
                    String[] locationsArray = new String[this.numVpdRecords];
                    for (int i = 0; i < this.numVpdRecords; ++i) {
                        locationsArray[i] = ((VpdFileRecord)this.frus.get(i)).getFruLocation();
                    }
                    DisplayLocationsBean bean = new DisplayLocationsBean();
                    bean.setFrus(locationsArray);
                    taskletResponse.openModalChild(AUIML_FILE_NAME, DISPLAY_LOCS_PANEL_NAME, bean);
                    break block56;
                }
                if (actionString.equals("SearchOnRb")) {
                    Trace.trace(TRACE_MASKF, "Search on PN, MT, Loc or CCIN");
                    TypeOfSearchBean bean = new TypeOfSearchBean();
                    taskletResponse.openModalChild(AUIML_FILE_NAME, SEARCH_TYPE_PANEL_NAME, bean);
                    break block56;
                }
                if (actionString.equals("LocationRb") || actionString.equals("PartNumberRb") || actionString.equals("CcinRb") || actionString.equals("MachineTypeRb")) {
                    Trace.trace(TRACE_MASKF, "Display the SearchKeyWord Panel");
                    this.typeOfSearchString = actionString;
                    SearchKeyWordBean bean = new SearchKeyWordBean();
                    bean.setSearchType(this.typeOfSearchString);
                    taskletResponse.openModalChild(AUIML_FILE_NAME, SEARCH_STRING_PANEL_NAME, bean);
                    break block56;
                }
                if (actionString.equals("performSearch")) {
                    Trace.trace(TRACE_MASKF, "Retrieve the search string & perform the search");
                    VpdData vpddata = new VpdData();
                    String searchString = (String)taskletRequest.getData("searchString");
                    searchString = searchString.toUpperCase();
                    Trace.trace(TRACE_MASKF, "Performing a search of VPD");
                    if (this.typeOfSearchString.equals("LocationRb")) {
                        Trace.trace(TRACE_MASKF, "Searching for Location " + searchString);
                        vpddata.setVpdCommand(VpdRequestValue.SEARCH_LOCATION);
                        vpddata.getVpdInputData().setFruLocation(searchString);
                    } else if (this.typeOfSearchString.equals("PartNumberRb")) {
                        Trace.trace(TRACE_MASKF, "Searching for Part Number " + searchString);
                        vpddata.setVpdCommand(VpdRequestValue.SEARCH_PN);
                        vpddata.getVpdInputData().setFruPn(searchString);
                    } else if (this.typeOfSearchString.equals("CcinRb")) {
                        Trace.trace(TRACE_MASKF, "Searching for CCIN " + searchString);
                        vpddata.setVpdCommand(VpdRequestValue.SEARCH_CCIN);
                        vpddata.getVpdInputData().setFruCcin(searchString);
                    } else if (this.typeOfSearchString.equals("MachineTypeRb")) {
                        Trace.trace(TRACE_MASKF, "Searching for Machine Type " + searchString);
                        vpddata.setVpdCommand(VpdRequestValue.SEARCH_MACHINE_TYPE);
                        vpddata.getVpdInputData().setFruCcin(searchString);
                    }
                    VpdManager vpdmgr = VpdManager.getVpdManager();
                    try {
                        vpddata = vpdmgr.callVpdManager(vpddata);
                        this.frus = new ArrayList(vpddata.getSearchData());
                        int numVpdRecords = this.frus.size();
                        String[] locationsArray = new String[numVpdRecords];
                        Trace.trace(TRACE_MASKF, "Search results --");
                        for (int i = 0; i < numVpdRecords; ++i) {
                            locationsArray[i] = ((VpdFileRecord)this.frus.get(i)).getFruLocation();
                            Trace.trace(TRACE_MASKF, "location " + (i + 1) + " = " + locationsArray[i]);
                        }
                        DisplayLocationsBean bean = new DisplayLocationsBean();
                        bean.setFrus(locationsArray);
                        taskletResponse.openModalChild(AUIML_FILE_NAME, DISPLAY_LOCS_PANEL_NAME, bean);
                    }
                    catch (VpdManagerNotFoundException notFoundExc) {
                        BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                        MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.NOMATCH.TEXT", new Object[]{searchString})};
                        LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                        taskletResponse.noAction();
                    }
                    break block56;
                }
                if (actionString.equals("DisplayOrAlterSystemDataRb")) {
                    Trace.trace(TRACE_MASKF, "DisplayOrAlterSystemData");
                    try {
                        VpdData vpddata = new VpdData(VpdRequestValue.CONFIG_REQUEST);
                        VpdManager Vpd = VpdManager.getVpdManager();
                        vpddata = Vpd.callVpdManager(vpddata);
                        Trace.trace(TRACE_MASKF, "Setting SE machine model  = " + vpddata.getVpdConfigurationExistData().getMachineModel().trim());
                        Trace.trace(TRACE_MASKF, "Setting SE machine type   = " + vpddata.getVpdConfigurationExistData().getMachineType().trim());
                        Trace.trace(TRACE_MASKF, "Setting SE machine serial = " + vpddata.getVpdConfigurationExistData().getMachineSerial().trim());
                        VpdConfigurationData vpdcData = vpddata.getVpdConfigurationExistData();
                        this.saveMachCfgData = vpddata.getVpdConfigurationExistData();
                        ChangeMachineConfigDataBean bean = new ChangeMachineConfigDataBean();
                        bean.setMachineModelEdit(vpdcData.getMachineModel().trim());
                        bean.setMachineTypeEdit(vpdcData.getMachineType().trim());
                        bean.setMachineSerialNumberEdit(vpdcData.getMachineSerial().trim());
                        bean.setIoWorldWidePortNumberEdit(vpdcData.getIoWorldWidePortNumber().trim());
                        bean.setCecLocationEdit(vpdcData.getCecLocation().trim());
                        bean.setExpansionBoxLocationEdit(vpdcData.getExpBoxLocation().trim());
                        bean.setCecSerialNumberEdit(vpdcData.getCecSerial().trim());
                        taskletResponse.openModalChild(AUIML_FILE_NAME, MACH_CFG_PANEL_NAME, bean);
                    }
                    catch (VpdManagerNotFoundException notFoundExc) {
                        Trace.trace(TRACE_MASKF, "ERROR Restoring the original VPD and VPDC files");
                        BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                        MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.ERROR.TEXT", null)};
                        LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                        taskletResponse.noAction();
                    }
                    break block56;
                }
                if (actionString.equals("UpdateVpdButton")) {
                    Trace.trace(TRACE_MASKF, "UpdateVpdButton on VPDC Cfg Data");
                    VpdData vpddata = new VpdData(VpdRequestValue.CONFIG_ALTER_NULL);
                    ChangeMachineConfigDataBean changedCfgBean = (ChangeMachineConfigDataBean)taskletRequest.getData("CfgPanelData");
                    vpddata.getVpdConfigurationNewData().setCecLocation(changedCfgBean.getCecLocationEdit());
                    vpddata.getVpdConfigurationNewData().setCecSerial(changedCfgBean.getCecSerialNumberEdit());
                    vpddata.getVpdConfigurationNewData().setExpBoxLocation(changedCfgBean.getExpansionBoxLocationEdit());
                    vpddata.getVpdConfigurationNewData().setMachineModel(changedCfgBean.getMachineModelEdit());
                    vpddata.getVpdConfigurationNewData().setMachineSerial(changedCfgBean.getMachineSerialNumberEdit());
                    vpddata.getVpdConfigurationNewData().setMachineType(changedCfgBean.getMachineTypeEdit());
                    vpddata.getVpdConfigurationNewData().setIoWorldWidePortNumber(changedCfgBean.getIoWorldWidePortNumberEdit());
                    Trace.trace(TRACE_MASKF, "Setting SE Machine Model  = " + vpddata.getVpdConfigurationNewData().getMachineModel().trim());
                    Trace.trace(TRACE_MASKF, "Setting SE Machine Type   = " + vpddata.getVpdConfigurationNewData().getMachineType().trim());
                    Trace.trace(TRACE_MASKF, "Setting SE Machine Serial = " + vpddata.getVpdConfigurationNewData().getMachineSerial().trim());
                    Trace.trace(TRACE_MASKF, "Setting SE CEC Location   = " + vpddata.getVpdConfigurationNewData().getCecLocation().trim());
                    Trace.trace(TRACE_MASKF, "Setting SE CEC Serial     = " + vpddata.getVpdConfigurationNewData().getCecSerial().trim());
                    Trace.trace(TRACE_MASKF, "Setting SE Exp Box Loc    = " + vpddata.getVpdConfigurationNewData().getExpBoxLocation().trim());
                    Trace.trace(TRACE_MASKF, "Setting SE IO WW Port Num = " + vpddata.getVpdConfigurationNewData().getIoWorldWidePortNumber().trim());
                    try {
                        VpdManager Vpd = VpdManager.getVpdManager();
                        vpddata = Vpd.callVpdManager(vpddata);
                        BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                        MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.SUCCESS.TEXT", null)};
                        LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                        VpdConfigurationData vpdcData = vpddata.getVpdConfigurationNewData();
                        ChangeMachineConfigDataBean bean = new ChangeMachineConfigDataBean();
                        bean.setMachineModelEdit(vpdcData.getMachineModel().trim());
                        bean.setMachineTypeEdit(vpdcData.getMachineType().trim());
                        bean.setMachineSerialNumberEdit(vpdcData.getMachineSerial().trim());
                        bean.setIoWorldWidePortNumberEdit(vpdcData.getIoWorldWidePortNumber().trim());
                        bean.setCecLocationEdit(vpdcData.getCecLocation().trim());
                        bean.setExpansionBoxLocationEdit(vpdcData.getExpBoxLocation().trim());
                        bean.setCecSerialNumberEdit(vpdcData.getCecSerial().trim());
                        taskletResponse.openModalChild(AUIML_FILE_NAME, MACH_CFG_PANEL_NAME, bean);
                    }
                    catch (VpdManagerNotFoundException notFoundExc) {
                        BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                        MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.ERROR.TEXT", null)};
                        LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                        taskletResponse.noAction();
                    }
                    break block56;
                }
                if (actionString.equals("UndoLastActionButton")) {
                    Trace.trace(TRACE_MASKF, "UndoLastActionButton on VPDC Cfg Data");
                    try {
                        VpdData vpddata = new VpdData(VpdRequestValue.CONFIG_ALTER_NULL);
                        vpddata.setVpdConfigurationNewData(this.saveMachCfgData);
                        Trace.trace(TRACE_MASKF, "Setting SE Machine Model  = " + vpddata.getVpdConfigurationNewData().getMachineModel().trim());
                        Trace.trace(TRACE_MASKF, "Setting SE Machine Type   = " + vpddata.getVpdConfigurationNewData().getMachineType().trim());
                        Trace.trace(TRACE_MASKF, "Setting SE Machine Serial = " + vpddata.getVpdConfigurationNewData().getMachineSerial().trim());
                        Trace.trace(TRACE_MASKF, "Setting SE CEC Location   = " + vpddata.getVpdConfigurationNewData().getCecLocation().trim());
                        Trace.trace(TRACE_MASKF, "Setting SE CEC Serial     = " + vpddata.getVpdConfigurationNewData().getCecSerial().trim());
                        Trace.trace(TRACE_MASKF, "Setting SE Exp Box Loc    = " + vpddata.getVpdConfigurationNewData().getExpBoxLocation().trim());
                        Trace.trace(TRACE_MASKF, "Setting SE IO WW Port Num = " + vpddata.getVpdConfigurationNewData().getIoWorldWidePortNumber().trim());
                        Trace.trace(TRACE_MASKF, "Existing VPDC Version Num = " + vpddata.getVpdConfigurationNewData().getVersion().trim());
                        VpdManager Vpd = VpdManager.getVpdManager();
                        vpddata = Vpd.callVpdManager(vpddata);
                        VpdConfigurationData vpdcData = vpddata.getVpdConfigurationNewData();
                        ChangeMachineConfigDataBean bean = new ChangeMachineConfigDataBean();
                        bean.setMachineModelEdit(vpdcData.getMachineModel().trim());
                        bean.setMachineTypeEdit(vpdcData.getMachineType().trim());
                        bean.setMachineSerialNumberEdit(vpdcData.getMachineSerial().trim());
                        bean.setIoWorldWidePortNumberEdit(vpdcData.getIoWorldWidePortNumber().trim());
                        bean.setCecLocationEdit(vpdcData.getCecLocation().trim());
                        bean.setExpansionBoxLocationEdit(vpdcData.getExpBoxLocation().trim());
                        bean.setCecSerialNumberEdit(vpdcData.getCecSerial().trim());
                        BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                        MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.SUCCESS.TEXT", null)};
                        LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                        taskletResponse.openModalChild(AUIML_FILE_NAME, MACH_CFG_PANEL_NAME, bean);
                    }
                    catch (VpdManagerNotFoundException notFoundExc) {
                        BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                        MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.ERROR.TEXT", null)};
                        LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                        taskletResponse.noAction();
                    }
                    break block56;
                }
                if (actionString.equals("DisplaySelectionLocationButton")) {
                    Trace.trace(TRACE_MASKF, "DisplaySelectionLocations Panel ");
                    String sLocation = (String)taskletRequest.getData("location");
                    VpdFileRecord record = null;
                    for (int i = 0; i < this.numVpdRecords; ++i) {
                        record = (VpdFileRecord)this.frus.get(i);
                        if (!sLocation.equals(record.getFruLocation())) continue;
                        this.currentIndex = i;
                        Trace.trace(TRACE_MASKF, "Found location " + sLocation + " at index " + i);
                        break;
                    }
                    taskletResponse.openModalChild(AUIML_FILE_NAME, CHANGE_FRU_DATA_PANEL_NAME, this.setupFruDataBean(this.currentIndex));
                    break block56;
                }
                if (actionString.equals("RestorFruSystemData")) {
                    Trace.trace(TRACE_MASKF, "RestorFruSystemData");
                    String dataFilePath = BaseFileControl.getFilePath(VPD_FN);
                    FileOutputStream vpdStream = new FileOutputStream(dataFilePath + VPD_FN);
                    vpdStream.write(this.vpdfile);
                    vpdStream.close();
                    vpdStream = new FileOutputStream(dataFilePath + VPDC_FN);
                    vpdStream.write(this.vpdcfile);
                    vpdStream.close();
                    BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                    MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.SUCCESS.TEXT", null)};
                    LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                    taskletResponse.noAction();
                    break block56;
                }
                if (actionString.equals("PerformSelectedActionButton")) {
                    Trace.trace(TRACE_MASKF, "PerformSelectedActionButton");
                    try {
                        String option = (String)taskletRequest.getData("VpdRbAction");
                        ChangeFruDataBean changedBean = (ChangeFruDataBean)taskletRequest.getData("NewPanelData");
                        VpdData vpddata = new VpdData();
                        VpdFileRecord currentRecord = null;
                        currentRecord = (VpdFileRecord)this.frus.get(this.currentIndex);
                        VpdFileRecord tempRecord = new VpdFileRecord();
                        tempRecord.setFruLocation(currentRecord.getFruLocation());
                        tempRecord.getDeviceFileData().setFeatureCode(currentRecord.getDeviceFileData().getFeatureCode());
                        tempRecord.getDeviceFileData().setMachineModel(currentRecord.getDeviceFileData().getMachineModel());
                        tempRecord.getDeviceFileData().setMachineSerial(currentRecord.getDeviceFileData().getMachineSerial());
                        tempRecord.getDeviceFileData().setMachineType(currentRecord.getDeviceFileData().getMachineType());
                        tempRecord.getFruFileData().setCcin(currentRecord.getFruFileData().getCcin());
                        tempRecord.getFruFileData().setEcLevel(currentRecord.getFruFileData().getEcLevel());
                        tempRecord.getFruFileData().setFeature(currentRecord.getFruFileData().getFeature());
                        tempRecord.getFruFileData().setPartNumber(currentRecord.getFruFileData().getPartNumber());
                        tempRecord.getFruFileData().setSerialNumber(currentRecord.getFruFileData().getSerialNumber());
                        tempRecord.getFruFileData().setTod(currentRecord.getFruFileData().getTod());
                        String panelLocation = changedBean.getLocationEdit();
                        Trace.trace(TRACE_MASKF, "Current frus  location = " + currentRecord.getFruLocation() + " at index " + this.currentIndex);
                        Trace.trace(TRACE_MASKF, "Current Panel location = " + panelLocation);
                        if (option.equals("UpdateVpdRb")) {
                            Trace.trace(TRACE_MASKF, "User wants to ALTER location " + panelLocation);
                            this.lastRecord = tempRecord;
                            this.lastAction = VpdRequestValue.ALTER_NULL;
                            this.lastIndex = this.currentIndex;
                            vpddata.setVpdCommand(VpdRequestValue.ALTER_NULL);
                            vpddata.getVpdInputData().setFruLocation(panelLocation);
                            vpddata.getVpdFruNewData().setCcin(changedBean.getCcinEdit());
                            vpddata.getVpdFruNewData().setEcLevel(changedBean.getEcNumberEdit());
                            vpddata.getVpdFruNewData().setFeature(changedBean.getPartFeatureCodeEdit());
                            vpddata.getVpdFruNewData().setPartNumber(changedBean.getPartNumberEdit());
                            vpddata.getVpdFruNewData().setSerialNumber(changedBean.getSerialNumberEdit());
                            vpddata.getVpdFruNewData().setTod(changedBean.getTodLastUpdatedOutput());
                            vpddata.getVpdDeviceNewData().setFeatureCode(changedBean.getFeatureNumberEdit());
                            vpddata.getVpdDeviceNewData().setMachineModel(changedBean.getMachineModelEdit());
                            vpddata.getVpdDeviceNewData().setMachineSerial(changedBean.getMachineSerialNumberEdit());
                            vpddata.getVpdDeviceNewData().setMachineType(changedBean.getMachineTypeEdit());
                            currentRecord.setFruLocation(vpddata.getVpdInputData().getFruLocation());
                            currentRecord.setDeviceFileData(vpddata.getVpdDeviceNewData());
                            currentRecord.setFruFileData(vpddata.getVpdFruNewData());
                        } else if (option.equals("DeleteVpdRb")) {
                            Trace.trace(TRACE_MASKF, "User wants to DELETE location " + currentRecord.getFruLocation());
                            this.lastRecord = tempRecord;
                            this.lastAction = VpdRequestValue.DELETE;
                            this.lastIndex = this.currentIndex;
                            vpddata.setVpdCommand(VpdRequestValue.DELETE);
                            vpddata.getVpdInputData().setFruLocation(currentRecord.getFruLocation());
                        } else if (option.equals("UndoLastActionRb")) {
                            Trace.trace(TRACE_MASKF, "User wants to UNDO the last action at location " + this.lastRecord.getFruLocation());
                            vpddata.setVpdCommand(VpdRequestValue.ALTER_NULL);
                            vpddata.getVpdInputData().setFruLocation(this.lastRecord.getFruLocation());
                            vpddata.setVpdFruNewData(this.lastRecord.getFruFileData());
                            vpddata.setVpdDeviceNewData(this.lastRecord.getDeviceFileData());
                            Trace.trace(TRACE_MASKF, "Calling VPD Manager with UNDO location " + vpddata.getVpdInputData().getFruLocation());
                            Trace.trace(TRACE_MASKF, "Last VPD call Machine Type was " + vpddata.getVpdDeviceNewData().getMachineType());
                            Trace.trace(TRACE_MASKF, "Last VPD call Part Number was " + vpddata.getVpdFruNewData().getPartNumber());
                        }
                        VpdManager vpdmgr = VpdManager.getVpdManager();
                        vpddata = vpdmgr.callVpdManager(vpddata);
                        if (option.equals("DeleteVpdRb")) {
                            Trace.trace(TRACE_MASKF, "Making DELETE adjustments");
                            currentRecord = (VpdFileRecord)this.frus.remove(this.currentIndex);
                            if (this.currentIndex == this.numVpdRecords - 1) {
                                --this.currentIndex;
                            }
                            --this.numVpdRecords;
                        } else if (option.equals("UndoLastActionRb")) {
                            Trace.trace(TRACE_MASKF, "Making UNDO adjustments");
                            if (this.lastAction == VpdRequestValue.DELETE) {
                                Trace.trace(TRACE_MASKF, "UNDO a DELETE adjustments");
                                this.currentIndex = this.lastIndex;
                                this.frus.add(this.currentIndex, this.lastRecord);
                                ++this.numVpdRecords;
                            } else if (this.lastAction == VpdRequestValue.ALTER_NULL) {
                                this.currentIndex = this.lastIndex;
                                this.frus.set(this.currentIndex, this.lastRecord);
                            }
                        } else if (option.equals("UpdateVpdRb")) {
                            Trace.trace(TRACE_MASKF, "Making UPDATE adjustments");
                            this.frus.set(this.currentIndex, currentRecord);
                        }
                        Trace.trace(TRACE_MASKF, "Display VPD Editor Success Msg");
                        BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                        MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.SUCCESS.TEXT", null)};
                        LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                        if (option.equals("DeleteVpdRb") || option.equals("UndoLastActionRb")) {
                            Trace.trace(TRACE_MASKF, "Display the panel again");
                            taskletResponse.replace(AUIML_FILE_NAME, CHANGE_FRU_DATA_PANEL_NAME, this.setupFruDataBean(this.currentIndex));
                            break block56;
                        }
                        Trace.trace(TRACE_MASKF, "Leave UPDATE panel as is");
                        taskletResponse.noAction();
                    }
                    catch (VpdManagerNotFoundException notFoundExc) {
                        BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                        MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.ERROR.TEXT", null)};
                        LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                        taskletResponse.noAction();
                    }
                    break block56;
                }
                if (actionString.equals("DisplayPreviousLocationButton") || actionString.equals("DisplayNextLocationButton")) {
                    Trace.trace(TRACE_MASKF, "DisplayPreviousLocationsButton -OR-");
                    Trace.trace(TRACE_MASKF, "DisplayNextLocationsButton");
                    if (actionString.equals("DisplayPreviousLocationButton")) {
                        if (this.currentIndex == 0) {
                            BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                            MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.ATSTART.TEXT", null)};
                            LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                        } else {
                            --this.currentIndex;
                        }
                    } else if (this.currentIndex == this.frus.size() - 1) {
                        BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
                        MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.ATEND.TEXT", null)};
                        LocalizableText buttonPressed = this.showMessageBox(true, title, messageText, null, null, null);
                    } else {
                        ++this.currentIndex;
                    }
                    Trace.trace(TRACE_MASKF, "Displaying location " + ((VpdFileRecord)this.frus.get(this.currentIndex)).getFruLocation() + " at index " + this.currentIndex);
                    taskletResponse.replace(AUIML_FILE_NAME, CHANGE_FRU_DATA_PANEL_NAME, this.setupFruDataBean(this.currentIndex));
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception = " + e);
                e.printStackTrace();
                this.logException(e);
                taskletResponse.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- VpdEditTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> VpdEditTasklet.logException()");
        Trace.trace(TRACE_MASKF, "Exception = " + throwable);
        throwable.printStackTrace();
        Trace.trace(TRACE_MASKT, "<- VpdEditTasklet.logException()");
    }

    private ChangeFruDataBean setupFruDataBean(int index) {
        Trace.trace(TRACE_MASKF, "->setupFruDataBean");
        ChangeFruDataBean bean = new ChangeFruDataBean();
        VpdFileRecord record = (VpdFileRecord)this.frus.get(index);
        VpdFruData fruFileData = record.getFruFileData();
        VpdDeviceData deviceFileData = record.getDeviceFileData();
        bean.setTodLastUpdatedOutput(fruFileData.getTod());
        bean.setLocationEdit(record.getFruLocation());
        bean.setSerialNumberEdit(fruFileData.getSerialNumber());
        bean.setCcinEdit(fruFileData.getCcin());
        bean.setPartFeatureCodeEdit(fruFileData.getFeature());
        bean.setPartNumberEdit(fruFileData.getPartNumber());
        bean.setMachineTypeEdit(deviceFileData.getMachineType());
        bean.setEcNumberEdit(fruFileData.getEcLevel());
        bean.setMachineModelEdit(deviceFileData.getMachineModel());
        bean.setFeatureNumberEdit(deviceFileData.getFeatureCode());
        bean.setMachineSerialNumberEdit(deviceFileData.getMachineSerial());
        return bean;
    }

    private void getAllVpdLocations() throws TaskletException, VpdManagerException {
        Trace.trace(TRACE_MASKF, "->GetAllVpdLocations");
        try {
            VpdData vpddata = new VpdData(VpdRequestValue.SEARCH_LOCATION);
            vpddata.getVpdInputData().setFruLocation("*");
            VpdManager vpdmgr = VpdManager.getVpdManager();
            vpddata = vpdmgr.callVpdManager(vpddata);
            this.frus = new ArrayList(vpddata.getSearchData());
            this.numVpdRecords = this.frus.size();
        }
        catch (VpdManagerNotFoundException notFoundExc) {
            BaseMessageTitle title = new BaseMessageTitle("VPDEDIT.TITLE");
            MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("VPDEDIT.NOVPD.TEXT", null)};
            LocalizableText localizableText = this.showMessageBox(true, title, messageText, null, null, null);
        }
    }
}

